#!/usr/local/cpanel/3rdparty/bin/perl
###############################################################################
# Copyright 2004-2020, Way to the Web Limited
# URL: http://www.configserver.com
# Email: sales@waytotheweb.com
###############################################################################
# start main
use File::Copy;
use File::Basename;
use strict;

my $option = "1";
if (-e "/usr/msfe/mailscannerq") {$option = "2"}

my $cpanel = 1;
unless (-e "/usr/local/cpanel/version") {$cpanel = 0}

my $owner = "mailnull:mail";
unless ($cpanel) {$owner = "mail:mail"}

my $requeue = 0;
print "Repairing exim split spool directories...\n";
foreach my $entry (('a'..'z','A'..'Z','0'..'9')) {
	if ($option eq "1") {
		mkdir ("/var/spool/exim_incoming/input/$entry");
	} else {
		mkdir ("/var/spool/exim/mailscanner/input/$entry");
	}
	mkdir ("/var/spool/exim/input/$entry");
	my @spooldir = glob("/var/spool/exim/input/$entry/*");
	foreach my $dfile (@spooldir) {
		my $filename = basename($dfile);
#		my $sixth = substr($filename, 5, 1);
#		if ($dfile =~ /-D$/ and $sixth ne $entry) {
#			print "$dfile in the wrong place [$entry] [$sixth]\n";
#			my $hfile = $dfile;
#			$hfile =~ s/-D$/-H/;
#			move ($dfile, "/var/spool/exim/input/$sixth/");
#			move ($hfile, "/var/spool/exim/input/$sixth/");
#			print "Requeued [$dfile] to [/var/spool/exim/input/$sixth/]\n";
		if ($dfile =~ /-D$/) {
			my $hfile = $dfile;
			$hfile =~ s/-D$/-H/;
			move ($dfile, "/var/spool/exim/input/");
			move ($hfile, "/var/spool/exim/input/");
			print "Requeued [$dfile] to [/var/spool/exim/input/]\n";

			$requeue = 1;
		}
	}
}
if ($option eq "1") {
	system ("chown -R $owner /var/spool/exim_incoming 2>/dev/null");
} else {
	system ("chown -R $owner /var/spool/exim/mailscanner 2>/dev/null");
}
system ("chown", "-R", "$owner", "/var/spool/exim/input/");
system ("chmod", "-R", "750", "/var/spool/exim/input/");

if ($requeue) {
	print "Forcing an exim to reprocess the queue in the background, this may take some time\n";
	system("exim -q &");
}

print "Done\n";
